/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.chunk_loading;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundForgetLevelChunkPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.chunk_loading.ChunkLoader;
import qouteall.imm_ptl.core.chunk_loading.ChunkVisibility;
import qouteall.imm_ptl.core.chunk_loading.DimensionalChunkPos;
import qouteall.imm_ptl.core.chunk_loading.ImmPtlChunkTickets;
import qouteall.imm_ptl.core.chunk_loading.PerformanceLevel;
import qouteall.imm_ptl.core.ducks.IEThreadedAnvilChunkStorage;
import qouteall.imm_ptl.core.network.PacketRedirection;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.my_util.SignalBiArged;

public class NewChunkTrackingGraph {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final int updateInterval = 13;
    public static final int defaultDelayUnloadGenerations = 4;
    private static final Map<ResourceKey<Level>, Long2ObjectOpenHashMap<Object2ObjectOpenHashMap<ServerPlayer, PlayerWatchRecord>>> chunkWatchRecords = new Object2ObjectOpenHashMap();
    private static final ArrayList<ChunkLoader> additionalChunkLoaders = new ArrayList();
    private static final Object2ObjectOpenHashMap<ServerPlayer, PlayerInfo> playerInfoMap = new Object2ObjectOpenHashMap();
    public static final SignalBiArged<ServerPlayer, DimensionalChunkPos> beginWatchChunkSignal = new SignalBiArged();
    public static final SignalBiArged<ServerPlayer, DimensionalChunkPos> endWatchChunkSignal = new SignalBiArged();
    private static int generationCounter = 0;

    private static Long2ObjectOpenHashMap<Object2ObjectOpenHashMap<ServerPlayer, PlayerWatchRecord>> getDimChunkWatchRecords(ResourceKey<Level> dimension) {
        return chunkWatchRecords.computeIfAbsent(dimension, k -> new Long2ObjectOpenHashMap());
    }

    public static PlayerInfo getPlayerInfo(ServerPlayer player) {
        return (PlayerInfo)playerInfoMap.computeIfAbsent((Object)player, k -> new PlayerInfo());
    }

    public static void updateForPlayer(ServerPlayer player) {
        PlayerInfo playerInfo = NewChunkTrackingGraph.getPlayerInfo(player);
        playerInfo.visibleDimensions.clear();
        int lastLoadedChunks = playerInfo.loadedChunks;
        playerInfo.loadedChunks = 0;
        ObjectOpenHashSet chunkLoaders = new ObjectOpenHashSet();
        ChunkVisibility.foreachBaseChunkLoaders(player, arg_0 -> ((ObjectOpenHashSet)chunkLoaders).add(arg_0));
        chunkLoaders.addAll(playerInfo.additionalChunkLoaders);
        MinecraftServer server = MiscHelper.getServer();
        for (ChunkLoader chunkLoader : chunkLoaders) {
            ResourceKey<Level> dimension = chunkLoader.center.dimension;
            Long2ObjectOpenHashMap<Object2ObjectOpenHashMap<ServerPlayer, PlayerWatchRecord>> chunkRecordMap = NewChunkTrackingGraph.getDimChunkWatchRecords(dimension);
            ServerLevel world = server.m_129880_(dimension);
            if (world == null) {
                LOGGER.warn("Dimension not loaded {} in chunk loader {}", dimension, (Object)chunkLoader);
                return;
            }
            playerInfo.visibleDimensions.add(dimension);
            ImmPtlChunkTickets ticketInfo = ImmPtlChunkTickets.get(world);
            chunkLoader.foreachChunkPos((dim, x, z, distanceToSource) -> {
                long chunkPos = ChunkPos.m_45589_((int)x, (int)z);
                Object2ObjectOpenHashMap records = (Object2ObjectOpenHashMap)chunkRecordMap.computeIfAbsent(chunkPos, k -> new Object2ObjectOpenHashMap());
                ticketInfo.markForLoading(chunkPos, distanceToSource, generationCounter);
                records.compute((Object)player, (k, record) -> {
                    boolean isBoundary;
                    boolean bl = isBoundary = distanceToSource == chunkLoader.radius;
                    if (record == null) {
                        PlayerWatchRecord newRecord = new PlayerWatchRecord(player, dimension, chunkPos, generationCounter, distanceToSource, false, isBoundary);
                        playerInfo.markPendingLoading(newRecord);
                        ++playerInfo.loadedChunks;
                        return newRecord;
                    }
                    int oldDistance = record.distanceToSource;
                    if (record.lastWatchGeneration == generationCounter) {
                        if (distanceToSource < oldDistance) {
                            record.distanceToSource = distanceToSource;
                            playerInfo.markPendingLoading((PlayerWatchRecord)record);
                        }
                        record.isBoundary = record.isBoundary && isBoundary;
                    } else {
                        ++playerInfo.loadedChunks;
                        if (distanceToSource < oldDistance) {
                            playerInfo.markPendingLoading((PlayerWatchRecord)record);
                        }
                        record.distanceToSource = distanceToSource;
                        record.lastWatchGeneration = generationCounter;
                        record.isBoundary = isBoundary;
                    }
                    return record;
                });
            });
        }
    }

    public static void flushPendingLoading(ServerPlayer player, int generation) {
        PlayerInfo playerInfo = NewChunkTrackingGraph.getPlayerInfo(player);
        int limit = NewChunkTrackingGraph.getChunkDeliveringLimitPerTick(player);
        int loaded = 0;
        for (int distance = 0; distance < playerInfo.distanceToPendingChunks.size(); ++distance) {
            ArrayDeque<PlayerWatchRecord> records = playerInfo.distanceToPendingChunks.get(distance);
            if (records == null) continue;
            while (!records.isEmpty() && loaded < limit) {
                PlayerWatchRecord record = records.pollFirst();
                if (!record.isValid || record.isLoadedToPlayer) continue;
                record.isLoadedToPlayer = true;
                ServerLevel world = MiscHelper.getServer().m_129880_(record.dimension);
                if (world != null) {
                    ChunkPos chunkPos = new ChunkPos(record.chunkPos);
                    beginWatchChunkSignal.emit(player, new DimensionalChunkPos(record.dimension, chunkPos));
                    ++loaded;
                    continue;
                }
                LOGGER.error("Missing dimension when flushing pending loading {}", (Object)record.dimension.m_135782_());
            }
        }
    }

    private static int getChunkDeliveringLimitPerTick(ServerPlayer player) {
        return 200;
    }

    private static void purge(Object2ObjectOpenHashMap<ResourceKey<Level>, LongOpenHashSet> additionalLoadedChunks) {
        chunkWatchRecords.forEach((dimension, chunkRecords) -> chunkRecords.long2ObjectEntrySet().removeIf(entry -> {
            long chunkPosLong = entry.getLongKey();
            Object2ObjectOpenHashMap dimChunkWatchRecords = (Object2ObjectOpenHashMap)entry.getValue();
            dimChunkWatchRecords.entrySet().removeIf(e -> {
                boolean shouldRemove;
                ServerPlayer player = (ServerPlayer)e.getKey();
                if (player.m_213877_()) {
                    return true;
                }
                PlayerWatchRecord record = (PlayerWatchRecord)e.getValue();
                int delayUnloadGenerations = NewChunkTrackingGraph.getDelayUnloadGenerationForPlayer(player);
                boolean bl = shouldRemove = generationCounter - record.lastWatchGeneration > delayUnloadGenerations;
                if (shouldRemove) {
                    if (record.isLoadedToPlayer) {
                        endWatchChunkSignal.emit(record.player, new DimensionalChunkPos((ResourceKey<Level>)dimension, ChunkPos.m_45592_((long)chunkPosLong), ChunkPos.m_45602_((long)chunkPosLong)));
                    }
                    record.isValid = false;
                }
                return shouldRemove;
            });
            return dimChunkWatchRecords.isEmpty();
        }));
        playerInfoMap.entrySet().removeIf(e -> ((ServerPlayer)e.getKey()).m_213877_());
        MinecraftServer server = MiscHelper.getServer();
        for (ServerLevel world : server.m_129785_()) {
            ResourceKey dimension2 = world.m_46472_();
            @Nullable LongOpenHashSet additional = (LongOpenHashSet)additionalLoadedChunks.get((Object)dimension2);
            Long2ObjectOpenHashMap<Object2ObjectOpenHashMap<ServerPlayer, PlayerWatchRecord>> watchRecs = chunkWatchRecords.get(dimension2);
            ImmPtlChunkTickets dimTicketManager = ImmPtlChunkTickets.get(world);
            dimTicketManager.purge(world, chunkPos -> {
                if (watchRecs != null && watchRecs.containsKey(chunkPos)) {
                    return true;
                }
                return additional != null && additional.contains(chunkPos);
            });
        }
    }

    private static int getDelayUnloadGenerationForPlayer(ServerPlayer player) {
        PlayerInfo playerInfo = NewChunkTrackingGraph.getPlayerInfo(player);
        if (playerInfo == null) {
            return 4;
        }
        int loadedChunks = playerInfo.loadedChunks;
        if (loadedChunks > 2000) {
            return 1;
        }
        if (loadedChunks > 1200) {
            return 2;
        }
        return 4;
    }

    private static Object2ObjectOpenHashMap<ResourceKey<Level>, LongOpenHashSet> refreshAdditionalChunkLoaders() {
        Object2ObjectOpenHashMap additionalLoadedChunks = new Object2ObjectOpenHashMap();
        additionalChunkLoaders.removeIf(chunkLoader -> {
            ResourceKey<Level> dimension = chunkLoader.center.dimension;
            ServerLevel world = MiscHelper.getServer().m_129880_(dimension);
            if (world == null) {
                LOGGER.error("Missing dimension in chunk loader {}", (Object)dimension.m_135782_());
                return true;
            }
            final ImmPtlChunkTickets dimTicketManager = ImmPtlChunkTickets.get(world);
            final LongOpenHashSet set = (LongOpenHashSet)additionalLoadedChunks.computeIfAbsent(dimension, k -> new LongOpenHashSet());
            chunkLoader.foreachChunkPos(new ChunkLoader.ChunkPosConsumer(){

                @Override
                public void consume(ResourceKey<Level> dimension, int x, int z, int distanceToSource) {
                    long chunkPos = ChunkPos.m_45589_((int)x, (int)z);
                    dimTicketManager.markForLoading(chunkPos, distanceToSource, generationCounter);
                    set.add(chunkPos);
                }
            });
            return false;
        });
        return additionalLoadedChunks;
    }

    private static void tick() {
        MinecraftServer server = MiscHelper.getServer();
        server.m_129905_().m_6180_("portal_chunk_tracking");
        long gameTime = McHelper.getOverWorldOnServer().m_46467_();
        server.m_6846_().m_11314_().forEach(player -> {
            PlayerInfo playerInfo = NewChunkTrackingGraph.getPlayerInfo(player);
            if (playerInfo.shouldUpdateImmediately || (long)(player.m_19879_() % 13) == gameTime % 13L) {
                playerInfo.shouldUpdateImmediately = false;
                NewChunkTrackingGraph.updateForPlayer(player);
            }
            NewChunkTrackingGraph.flushPendingLoading(player, generationCounter);
        });
        if (gameTime % 13L == 0L) {
            Object2ObjectOpenHashMap<ResourceKey<Level>, LongOpenHashSet> additionalLoadedChunks = NewChunkTrackingGraph.refreshAdditionalChunkLoaders();
            NewChunkTrackingGraph.purge(additionalLoadedChunks);
            ++generationCounter;
        }
        for (ServerLevel world : MiscHelper.getServer().m_129785_()) {
            ImmPtlChunkTickets dimTicketManager = ImmPtlChunkTickets.get(world);
            IEThreadedAnvilChunkStorage chunkMap = (IEThreadedAnvilChunkStorage)world.m_7726_().f_8325_;
            dimTicketManager.tick(world);
        }
        server.m_129905_().m_7238_();
    }

    public static void init() {
        IPGlobal.postServerTickSignal.connect(NewChunkTrackingGraph::tick);
        IPGlobal.serverCleanupSignal.connect(NewChunkTrackingGraph::cleanup);
    }

    public static boolean isPlayerWatchingChunk(ServerPlayer player, ResourceKey<Level> dimension, int x, int z, Predicate<PlayerWatchRecord> predicate) {
        long chunkPos = ChunkPos.m_45589_((int)x, (int)z);
        Object2ObjectOpenHashMap recordMap = (Object2ObjectOpenHashMap)NewChunkTrackingGraph.getDimChunkWatchRecords(dimension).get(chunkPos);
        if (recordMap == null) {
            return false;
        }
        PlayerWatchRecord record = (PlayerWatchRecord)recordMap.get((Object)player);
        if (record == null) {
            return false;
        }
        if (!record.isLoadedToPlayer) {
            return false;
        }
        return predicate.test(record);
    }

    public static boolean isPlayerWatchingChunk(ServerPlayer player, ResourceKey<Level> dimension, int x, int z) {
        return NewChunkTrackingGraph.isPlayerWatchingChunk(player, dimension, x, z, r -> true);
    }

    public static boolean isPlayerWatchingChunkWithinRadius(ServerPlayer player, ResourceKey<Level> dimension, int x, int z, int radiusBlocks) {
        return NewChunkTrackingGraph.isPlayerWatchingChunk(player, dimension, x, z, r -> r.distanceToSource * 16 <= radiusBlocks);
    }

    private static void cleanup() {
        chunkWatchRecords.clear();
        additionalChunkLoaders.clear();
        playerInfoMap.clear();
    }

    public static Stream<ServerPlayer> getPlayersViewingChunk(ResourceKey<Level> dimension, int x, int z) {
        Object2ObjectOpenHashMap<ServerPlayer, PlayerWatchRecord> records = NewChunkTrackingGraph.getPlayerWatchListRecord(dimension, x, z);
        if (records == null) {
            return Stream.empty();
        }
        return records.values().stream().filter(e -> e.isLoadedToPlayer).map(e -> e.player);
    }

    public static List<ServerPlayer> getPlayersViewingChunk(ResourceKey<Level> dimension, int x, int z, boolean boundaryOnly) {
        Object2ObjectOpenHashMap<ServerPlayer, PlayerWatchRecord> recs = NewChunkTrackingGraph.getPlayerWatchListRecord(dimension, x, z);
        if (recs == null) {
            return Collections.emptyList();
        }
        ArrayList<ServerPlayer> result = new ArrayList<ServerPlayer>();
        for (PlayerWatchRecord rec : recs.values()) {
            if (!rec.isLoadedToPlayer || boundaryOnly && !rec.isBoundary) continue;
            result.add(rec.player);
        }
        return result;
    }

    @Nullable
    public static Object2ObjectOpenHashMap<ServerPlayer, PlayerWatchRecord> getPlayerWatchListRecord(ResourceKey<Level> dimension, int x, int z) {
        return (Object2ObjectOpenHashMap)NewChunkTrackingGraph.getDimChunkWatchRecords(dimension).get(ChunkPos.m_45589_((int)x, (int)z));
    }

    public static void forceRemovePlayer(ServerPlayer player) {
        chunkWatchRecords.forEach((dim, dimMap) -> dimMap.long2ObjectEntrySet().removeIf(e -> {
            long chunkPos = e.getLongKey();
            Object2ObjectOpenHashMap records = (Object2ObjectOpenHashMap)e.getValue();
            PlayerWatchRecord rec = (PlayerWatchRecord)records.remove((Object)player);
            if (rec != null) {
                PacketRedirection.sendRedirectedMessage(player, (ResourceKey<Level>)dim, (Packet)new ClientboundForgetLevelChunkPacket(ChunkPos.m_45592_((long)chunkPos), ChunkPos.m_45602_((long)chunkPos)));
            }
            return records.isEmpty();
        }));
    }

    public static void forceRemoveDimension(ResourceKey<Level> dim) {
        Long2ObjectOpenHashMap<Object2ObjectOpenHashMap<ServerPlayer, PlayerWatchRecord>> map = chunkWatchRecords.get(dim);
        if (map == null) {
            return;
        }
        map.forEach((chunkPos, records) -> {
            Packet<ClientGamePacketListener> unloadPacket = PacketRedirection.createRedirectedMessage(dim, (Packet<ClientGamePacketListener>)new ClientboundForgetLevelChunkPacket(ChunkPos.m_45592_((long)chunkPos), ChunkPos.m_45602_((long)chunkPos)));
            for (PlayerWatchRecord record : records.values()) {
                if (record.isValid && record.isLoadedToPlayer) {
                    record.player.f_8906_.m_9829_(unloadPacket);
                }
                record.isValid = false;
            }
        });
        chunkWatchRecords.remove(dim);
        additionalChunkLoaders.removeIf(chunkLoader -> chunkLoader.center.dimension == dim);
        for (PlayerInfo playerInfo : playerInfoMap.values()) {
            playerInfo.additionalChunkLoaders.removeIf(l -> l.center.dimension == dim);
        }
    }

    public static boolean shouldLoadDimension(ResourceKey<Level> dimension) {
        if (!chunkWatchRecords.containsKey(dimension)) {
            return false;
        }
        Long2ObjectOpenHashMap<Object2ObjectOpenHashMap<ServerPlayer, PlayerWatchRecord>> map = chunkWatchRecords.get(dimension);
        return !map.isEmpty();
    }

    public static void addGlobalAdditionalChunkLoader(ChunkLoader chunkLoader) {
        additionalChunkLoaders.add(chunkLoader);
        ResourceKey<Level> dimension = chunkLoader.center.dimension;
        ServerLevel world = MiscHelper.getServer().m_129880_(dimension);
        if (world == null) {
            LOGGER.error("Missing dimension in chunk loader {}", (Object)dimension.m_135782_());
            return;
        }
        ImmPtlChunkTickets dimTicketManager = ImmPtlChunkTickets.get(world);
        chunkLoader.foreachChunkPos((dim, x, z, distanceToSource) -> dimTicketManager.markForLoading(ChunkPos.m_45589_((int)x, (int)z), distanceToSource, generationCounter));
    }

    public static void removeGlobalAdditionalChunkLoader(ChunkLoader chunkLoader) {
        additionalChunkLoaders.removeIf(c -> c == chunkLoader);
    }

    public static int getLoadedChunkNum(ResourceKey<Level> dimension) {
        return NewChunkTrackingGraph.getDimChunkWatchRecords(dimension).size();
    }

    public static void addPerPlayerAdditionalChunkLoader(ServerPlayer player, ChunkLoader chunkLoader) {
        PlayerInfo playerInfo = NewChunkTrackingGraph.getPlayerInfo(player);
        playerInfo.additionalChunkLoaders.add(chunkLoader);
        playerInfo.shouldUpdateImmediately = true;
    }

    public static void removePerPlayerAdditionalChunkLoader(ServerPlayer player, ChunkLoader chunkLoader) {
        ArrayList<ChunkLoader> chunkLoaderList = NewChunkTrackingGraph.getPlayerInfo((ServerPlayer)player).additionalChunkLoaders;
        chunkLoaderList.removeIf(c -> c == chunkLoader);
    }

    public static Set<ResourceKey<Level>> getVisibleDimensions(ServerPlayer player) {
        return NewChunkTrackingGraph.getPlayerInfo((ServerPlayer)player).visibleDimensions;
    }

    public static class PlayerInfo {
        public final Set<ResourceKey<Level>> visibleDimensions = new ObjectOpenHashSet();
        public final ArrayList<ChunkLoader> additionalChunkLoaders = new ArrayList();
        public final ArrayList<ArrayDeque<PlayerWatchRecord>> distanceToPendingChunks = new ArrayList();
        public int loadedChunks = 0;
        public boolean shouldUpdateImmediately = false;
        public PerformanceLevel performanceLevel = PerformanceLevel.bad;

        public void markPendingLoading(PlayerWatchRecord record) {
            Helper.arrayListComputeIfAbsent(this.distanceToPendingChunks, record.distanceToSource, ArrayDeque::new).add(record);
        }
    }

    public static class PlayerWatchRecord {
        public final ServerPlayer player;
        public final ResourceKey<Level> dimension;
        public final long chunkPos;
        public int lastWatchGeneration;
        public int distanceToSource;
        public boolean isLoadedToPlayer;
        public boolean isValid = true;
        public boolean isBoundary = false;

        public PlayerWatchRecord(ServerPlayer player, ResourceKey<Level> dimension, long chunkPos, int lastWatchGeneration, int distanceToSource, boolean isLoadedToPlayer, boolean isBoundary) {
            this.player = player;
            this.dimension = dimension;
            this.chunkPos = chunkPos;
            this.lastWatchGeneration = lastWatchGeneration;
            this.distanceToSource = distanceToSource;
            this.isLoadedToPlayer = isLoadedToPlayer;
            this.isBoundary = isBoundary;
        }

        public String toString() {
            return String.format("%s (%d,%d) distance:%d valid:%s loaded:%s", this.dimension.m_135782_(), ChunkPos.m_45592_((long)this.chunkPos), ChunkPos.m_45602_((long)this.chunkPos), this.distanceToSource, this.isValid, this.isLoadedToPlayer);
        }
    }

    public static class RemoteCallables {
        public static void acceptClientPerformanceInfo(ServerPlayer player, PerformanceLevel performanceLevel) {
            PlayerInfo playerInfo = NewChunkTrackingGraph.getPlayerInfo(player);
            playerInfo.performanceLevel = performanceLevel;
        }
    }
}

